/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.pa.sql.PAPEPartition;
import filenet.pe.ceutils.ConnectionPoint;
import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.pa.PADataFieldWizard;
import filenet.vw.apps.taskman.pa.panonrmi.IPANonRMI;
import filenet.vw.apps.taskman.pa.peconnection.IPEConnection;
import filenet.vw.apps.taskman.pa.peconnection.PEConnectionFactory;
import filenet.vw.apps.taskman.pa.peconnection.PEExposedLogField;
import filenet.vw.apps.taskman.pa.peconnection.PEExposedLogFields;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardControl;
import filenet.vw.apps.taskman.toolkit.dialog.IVWTaskWizardPanel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class PAPEConnectionPointPanel
extends JPanel
implements IVWTaskWizardPanel,
IVWTaskWizardControl,
ActionListener,
FocusListener {
    PADataFieldWizard m_dataFieldWizard = null;
    JComboBox m_connectionPoints = null;
    JTextField m_peNameField = null;
    JTextField m_regionField = null;
    Border m_textBorder = null;
    IPEConnection m_peConnection = null;
    private boolean m_bCPChanged = true;

    public PAPEConnectionPointPanel(PADataFieldWizard dataFieldWizard) {
        this.m_dataFieldWizard = dataFieldWizard;
        this.initLayout();
    }

    private void initLayout() {
        this.m_connectionPoints = new JComboBox();
        this.m_connectionPoints.addActionListener(this);
        this.m_connectionPoints.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, value != null ? ((ConnectionPoint)value).Name : "", index, isSelected, cellHasFocus);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 10);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(VWResource.Label.toString(VWResource.ConnectionPoint)), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        c.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.m_connectionPoints, c);
        c.insets = new Insets(10, 10, 0, 10);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(VWResource.Label.toString(VWResource.ProcessEngine)), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        c.insets = new Insets(10, 0, 0, 10);
        this.m_peNameField = new JTextField();
        this.m_peNameField.setEditable(false);
        this.m_peNameField.setBorder(null);
        this.m_peNameField.addFocusListener(this);
        this.add((Component)this.m_peNameField, c);
        c.insets = new Insets(10, 10, 0, 10);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel(VWResource.Label.toString(VWResource.IsolatedRegion)), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        c.insets = new Insets(10, 0, 0, 10);
        this.m_regionField = new JTextField();
        this.m_regionField.setEditable(false);
        this.m_regionField.setBorder(null);
        this.m_regionField.addFocusListener(this);
        this.add((Component)this.m_regionField, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.add(Box.createHorizontalStrut(0), c);
    }

    public void initializeFields() throws Exception {
        this.m_peConnection = PEConnectionFactory.getPEConnection(this.m_dataFieldWizard.getDataFieldsNode().getPANode());
        ConnectionPoint[] cps = this.m_peConnection.getConnectionPoints(this.m_dataFieldWizard.getDataFieldsNode().getPANode().getContentEngineURL(), this.m_dataFieldWizard.getDataFieldsNode().getPANode().getServiceUsername(), this.m_dataFieldWizard.getDataFieldsNode().getPANode().getServicePassword());
        if (cps != null) {
            this.m_connectionPoints.setModel(new DefaultComboBoxModel<ConnectionPoint>(cps));
        }
        if (cps != null && cps.length > 0) {
            this.m_peNameField.setText(((ConnectionPoint)this.m_connectionPoints.getSelectedItem()).DNSName);
            this.m_regionField.setText("" + ((ConnectionPoint)this.m_connectionPoints.getSelectedItem()).IsolatedRegionNumber);
        }
        this.m_bCPChanged = true;
    }

    public String getHelpPath() {
        return VWHelp.Help_Process_TaskManager + "pa_data_fields.htm";
    }

    public String getInstructions() {
        return VWResource.SelectCPtoGetDataFields;
    }

    public void performValidation() throws Exception {
        try {
            if (this.m_bCPChanged) {
                PEExposedLogFields fields;
                if (this.m_peConnection.isConnected()) {
                    this.m_peConnection.disconnect();
                }
                this.m_peConnection.connect(this.m_dataFieldWizard.getDataFieldsNode().getPANode().getContentEngineURL(), this.m_dataFieldWizard.getDataFieldsNode().getPANode().getServiceUsername(), this.m_dataFieldWizard.getDataFieldsNode().getPANode().getServicePassword(), this.getSelectedConnectionPoint().Name);
                this.m_dataFieldWizard.m_eventLogFieldPanel.m_logFields = fields = this.getEventLogFields();
                this.m_dataFieldWizard.m_eventLogFieldPanel.updateFieldCombo(true);
                this.m_dataFieldWizard.m_eventLogFieldPanel.updateControlsWithSelectedField();
                this.m_dataFieldWizard.updateButtonState();
                this.m_bCPChanged = false;
            }
        }
        catch (Exception e) {
            VWException vwEx = new VWException("filenet.vw.apps.taskman.pa.PAConnectDialogConnectEx", "A Process Engine connection could not be established.");
            vwEx.setCause(e);
            throw vwEx;
        }
    }

    private ConnectionPoint getSelectedConnectionPoint() {
        return (ConnectionPoint)this.m_connectionPoints.getSelectedItem();
    }

    public void refresh() {
    }

    public boolean skipThisPanel() {
        return !this.m_dataFieldWizard.IsSourcePESelected();
    }

    public boolean allowButtonToBeEnabled(int button) {
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_connectionPoints) {
            this.m_bCPChanged = true;
            this.m_peNameField.setText(((ConnectionPoint)this.m_connectionPoints.getSelectedItem()).DNSName);
            this.m_regionField.setText("" + ((ConnectionPoint)this.m_connectionPoints.getSelectedItem()).IsolatedRegionNumber);
        }
    }

    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable() || source instanceof JTextArea && !((JTextArea)source).isEditable()) {
            this.m_textBorder = ((JComponent)source).getBorder();
            ((JComponent)source).setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable() || source instanceof JTextArea && !((JTextArea)source).isEditable()) {
            ((JComponent)source).setBorder(this.m_textBorder);
        }
    }

    public PEExposedLogFields getEventLogFields() throws Exception {
        VWDebug.logInfo("Entering getEventLogFields()");
        VWDebug.logInfo("PE Connection region: " + this.m_peConnection.getIsolatedRegion());
        IPANonRMI paNonRMI = this.m_dataFieldWizard.getDataFieldsNode().getPANode().getPANonRMI();
        HashMap map = new HashMap();
        if (paNonRMI.isPAPEPartitionEnabled()) {
            PAPEPartition[] partitions = paNonRMI.getPAPEPartitions();
            for (int i = 0; i < partitions.length; ++i) {
                PAPEPartition p = partitions[i];
                if (p.getRegionId() != this.m_peConnection.getIsolatedRegion()) {
                    VWDebug.logInfo("Ignoring partition from region: " + p.getRegionId());
                    continue;
                }
                if (p.getEventLog() == null) {
                    VWDebug.logInfo("Found null event log partition.");
                    break;
                }
                String viewName = p.getEventLog();
                String logName = viewName.substring(viewName.indexOf("_") + 1);
                map.put(logName, null);
                VWDebug.logInfo("Adding partition event log: " + logName);
            }
        }
        PEExposedLogFields fields = null;
        fields = map.size() > 0 ? this.m_peConnection.getLogFields(map) : this.m_peConnection.getLogFields(null);
        VWDebug.logInfo("Here are the PE fields found for the event log: ");
        PEExposedLogField[] peFields = fields.getFields(true);
        for (int i = 0; i < peFields.length; ++i) {
            VWDebug.logInfo(peFields[i].getName());
        }
        return fields;
    }
}

